//=============================================================================
// Customized SplashLogo
//=============================================================================
class XmasSplash expands Actor config;

var config string LogoTexture;
var config float LogoDrawDelay;
var config float LogoFadeInTime;
var config float LogoDrawTime;
var config float LogoFadeOutTime;
var config string CaptionLineOne;
//var config string CaptionLineTwo;
//var config string CaptionLineThree;
//var config string CaptionLineFour;
var config string IntroSound;
var config float IntroSoundDelay;
var config string CustomRedFlag;
var config string CustomBlueFlag;
var config bool bLogoTranslucent;
var config string Position;
var config string Size;




var Texture FlagTeamTextures[2];
var Texture OrigTextures[2];

function PreBeginPlay()
{
	local SplashNotify s;



	s = spawn(class'SplashNotify');
	s.LogoTexture = LogoTexture;
	s.LogoDrawDelay = LogoDrawDelay;
	s.LogoFadeInTime = LogoFadeInTime;
	s.LogoDrawTime = LogoDrawTime;
	s.LogoFadeOutTime = LogoFadeOutTime;
	s.CaptionLineOne = CaptionLineOne;
	s.IntroSound = IntroSound;
	s.IntroSoundDelay = IntroSoundDelay;
	s.bLogoTranslucent = bLogoTranslucent;
	s.Position = Position;
	s.Size = Size;

	if(CustomRedFlag!="")
		FlagTeamTextures[0]=texture(DynamicLoadObject(CustomRedFlag, class'Texture'));
 	if(CustomBlueFlag!="")
		FlagTeamTextures[1]=texture(DynamicLoadObject(CustomBlueFlag, class'Texture'));

	if((FlagTeamTextures[0] != None || FlagTeamTextures[1] != None) && Level.Game.IsA('CTFGame'))
		SetTimer(1.0,True); /* 1.0 because there are some mutators messing with the flags in the first second */
}

simulated function Timer()
{
	local int i;
	local FlagBase Base;
	local CTFReplicationInfo CTFRI;

	foreach AllActors(class'FlagBase',Base)
	{
		if(Base.Team >1) // neither red nor blue
			continue;
		if (Base.Skin==OrigTextures[Base.Team])
		{
			if(FlagTeamTextures[Base.Team] != None)
				Base.Skin = FlagTeamTextures[Base.Team];
		}
	}
	CTFRI = CTFReplicationInfo(Level.Game.GameReplicationInfo);
	if (CTFRI!=None)
	{
		if ((CTFRI.FlagList[0]!=None) && (CTFRI.FlagList[0].Skin==OrigTextures[0]) && FlagTeamTextures[0] != None)
			CTFRI.FlagList[0].Skin = FlagTeamTextures[0];
		if ((CTFRI.FlagList[1]!=None) && (CTFRI.FlagList[1].Skin==OrigTextures[1]) && FlagTeamTextures[1] != None)
			CTFRI.FlagList[1].Skin = FlagTeamTextures[1];
	}
	Disable('Timer');
}

defaultproperties
{
     bHidden=True
}
